package w83b.w83bUtilidadesComunes;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;

import n38c.exe.N38API;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import es.ejie.frmk.infraestructura.seguridad.Q70GestorSeguridad;
import es.ejie.frmk.infraestructura.seguridad.Q70InformacionSeguridadUsuario;
import es.ejie.frmk.infraestructura.seguridad.Q70LogonException;
import es.ejie.frmk.infraestructura.seguridad.Q70SeguridadException;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;


/**
 * 
 * @author 
 *
 */
public abstract class W83bUtilidadesN38API{
	
	static Document xmlPersona = null;//NOPMD 
	  
	  /**
	   * Gets the parameters.
	   * 
	   * @param document the document
	   * @param parameter the parameter
	   * @return the parameters
	   * @throws TransformerException the transformer exception
	   */
	  private static List getParameters(HttpServletRequest request, String parameter)
	  throws TransformerException {
		 
		  try {
			  Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
			  Q70InformacionSeguridadUsuario infUsuario = gestorSeguridad.createSecurityUserInfo(request);

	    	return (Vector)infUsuario.getSessionSecurityInf(parameter);  
		  } catch (Q70SeguridadException e) {
			
			  W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			  return null;
		  } catch (Q70LogonException e) {
		
			  W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			  return null;
		  }
	  }
	  
	  /**
	   * Gets the parameters.
	   * 
	   * @param document the document
	   * @param parameter the parameter
	   * @return the parameters
	   * @throws TransformerException the transformer exception
	   */
	  private static String getSessionXML(HttpServletRequest request)
	  throws TransformerException {
		  
		  try {
			  Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
			  Q70InformacionSeguridadUsuario infUsuario = gestorSeguridad.createSecurityUserInfo(request);

			  OutputFormat format    = new OutputFormat (infUsuario.getXLNESessionTolkit().n38ItemSesion()); 
		   
		      StringWriter stringOut = new StringWriter ();    
		      XMLSerializer serial   = new XMLSerializer (stringOut, 
		                                                  format);
		      try {
				serial.serialize(infUsuario.getXLNESessionTolkit().n38ItemSesion());
			} catch (IOException e) {
				
				W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			}
		      // Display the XML

		      W83bClsTrazas.traza(null,stringOut.toString());

				  return stringOut.toString();  

		  } catch (Q70SeguridadException e) {

			  W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			  return null;
		  } catch (Q70LogonException e) {
			 
			  W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			  return null;
		  }
	  }
	  
	  /**
	   * Gets the parameters.
	   * 
	   * @param document the document
	   * @param parameter the parameter
	   * @return the parameters
	   * @throws TransformerException the transformer exception
	   */
	  private static Document getSessionXMLDoc(HttpServletRequest request)
	  throws TransformerException {

		  try {
			  Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
			  Q70InformacionSeguridadUsuario infUsuario = gestorSeguridad.createSecurityUserInfo(request);

				return infUsuario.getXLNESessionTolkit().n38ItemSesion();
			} catch (Q70SeguridadException e) {
				
				W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
				return null;
			} catch (Q70LogonException e) {
				
				W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
				return null;
			}  

	  }
  
	  

	  public static String getIdiomaXLnets(HttpServletRequest request){
		    try {
				return (String)getParameters(request, "n38idioma").get(0);				
			} catch (TransformerException e1) {
			
				W83bClsTrazas.trazaError(null,e1.getLocalizedMessage(),e1);
				return "";
			}
	  }
	  
//	  public static String getNombrePersona(HttpServletRequest request,String dni){
//		  Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
//		  Q70InformacionSeguridadUsuario infUsuario;
//		  try {
//				infUsuario = gestorSeguridad.createSecurityUserInfo(request);
//				N38API sessionTolkit = infUsuario.getXLNESessionTolkit();
//				
//				if(null==xmlPersona){
//				  xmlPersona  = sessionTolkit.n38ItemObtenerPersonas("dni="+dni);
//				}
//				String querie = "//elemento/parametro[@id=\"givenname\"]/valor/text()";
//				NodeList nodeNOMBRE = XPathAPI.selectNodeList(xmlPersona, querie);
//				return nodeNOMBRE.item(0).getNodeValue();
//			} catch (Q70SeguridadException e) {
//				
//				W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
//			} catch (Q70LogonException e) {
//				
//				W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
//			}catch (TransformerException e1) {
//				
//				W83bClsTrazas.trazaError(null,e1.getLocalizedMessage(),e1);
//			}catch (Exception e2) {
//				
//				W83bClsTrazas.trazaError(null,e2.getLocalizedMessage(),e2);
//			}
//		  
//		  return "";
//	  }
	  
	  
//	  public static String getTelefonoPersona(HttpServletRequest request,String dni){
//		  Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
//		  Q70InformacionSeguridadUsuario infUsuario;
//		  try {
//			  infUsuario = gestorSeguridad.createSecurityUserInfo(request);
//			  N38API sessionTolkit = infUsuario.getXLNESessionTolkit();
//			
//			  if(null==xmlPersona){
//				  xmlPersona  = sessionTolkit.n38ItemObtenerPersonas("dni="+dni);
//			  }
//			  String querie = "//elemento/parametro[@id=\"telephonenumber\"]/valor/text()";
//			  NodeList nodeNOMBRE = XPathAPI.selectNodeList(xmlPersona, querie);
//			  return nodeNOMBRE.item(0).getNodeValue();
//		} catch (Q70SeguridadException e) {
//			
//			W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
//		} catch (Q70LogonException e) {
//			
//			W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
//		}catch (TransformerException e1) {
//			
//			W83bClsTrazas.trazaError(null,e1.getLocalizedMessage(),e1);
//		}catch (Exception e2) {
//			
//			W83bClsTrazas.trazaError(null,e2.getLocalizedMessage(),e2);
//		}
//		  
//		  return "";
//	  }
	  
//	  public static String getMailPersona(HttpServletRequest request,String dni){
//		  
//			Q70InformacionSeguridadUsuario infUsuario;
//			try {
//				infUsuario = gestorSeguridad.createSecurityUserInfo(request);
//			N38API sessionTolkit = infUsuario.getXLNESessionTolkit();
//			
//		  if(null==xmlPersona){
//			  xmlPersona  = sessionTolkit.n38ItemObtenerPersonas("dni="+dni);
//		  }
//		  String querie = "//elemento/parametro[@id=\"mail\"]/valor/text()";
//		  NodeList nodeNOMBRE = XPathAPI.selectNodeList(xmlPersona, querie);
//		  return nodeNOMBRE.item(0).getNodeValue();
//			} catch (Q70SeguridadException e) {
//				
//				W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
//			} catch (Q70LogonException e) {
//				
//				W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
//			}catch (TransformerException e1) {
//				
//				W83bClsTrazas.trazaError(null,e1.getLocalizedMessage(),e1);
//			}catch (Exception e2) {
//				
//				W83bClsTrazas.trazaError(null,e2.getLocalizedMessage(),e2);
//			}
//		  
//		  return "";
//	  }
	  
	  public static String getNombrePersona(HttpServletRequest request,String dni)  {
		  String nombre = "";
          
          try {
        	  Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
        	  Q70InformacionSeguridadUsuario infUsuario;
        	  infUsuario = gestorSeguridad.createSecurityUserInfo(request);
	          
	          N38API sessionTolkit = infUsuario.getXLNESessionTolkit();
	          
	          
	          StringBuffer filtroPersona = new StringBuffer("(|");
	          filtroPersona.append("(dni=");
	          filtroPersona.append(dni);
	          filtroPersona.append(")");
	          filtroPersona.append(")");
	          Document document = sessionTolkit.n38ItemObtenerPersonas(filtroPersona.toString());
	          
	          NodeList lista = null;
	          
         
	            lista = XPathAPI.selectNodeList(document,"//elemento[@subtipo=\"n38persona\"]");
	            if (lista != null) {
	                  NodeList nlm = XPathAPI.selectNodeList(lista.item(0),
	                             "parametro[@id=\"givenname\"]/valor/text()");
	                  if (nlm.getLength() > 0) {
	                       nombre = nlm.item(0).getNodeValue();
	                  }
	            }
          } catch (Q70SeguridadException e) {
        	  W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
          } catch (Q70LogonException e) {
				W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
          } catch (TransformerException e) {
        	  W83bClsTrazas.trazaError(null,"Error con cdigo: " + dni + " - ERROR: "+ e.getMessage(),e);
          }

          return nombre;
    }
	  
	  
	  public static String getMailPersona(HttpServletRequest request,String dni)  {
		  String email = "";
          
          try {
        	  Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
        	  Q70InformacionSeguridadUsuario infUsuario;
        	  infUsuario = gestorSeguridad.createSecurityUserInfo(request);
	          
	          N38API sessionTolkit = infUsuario.getXLNESessionTolkit();
	          
	          
	          StringBuffer filtroPersona = new StringBuffer("(|");
	          filtroPersona.append("(dni=");
	          filtroPersona.append(dni);
	          filtroPersona.append(")");
	          filtroPersona.append(")");
	          Document document = sessionTolkit.n38ItemObtenerPersonas(filtroPersona.toString());
	          
	          NodeList lista = null;
	          
         
	            lista = XPathAPI.selectNodeList(document,"//elemento[@subtipo=\"n38persona\"]");
	            if (lista != null) {
	                  NodeList nlm = XPathAPI.selectNodeList(lista.item(0),
	                             "parametro[@id=\"mail\"]/valor/text()");
	                  if (nlm.getLength() > 0) {
	                       email = nlm.item(0).getNodeValue();
	                  }
	            }
          } catch (Q70SeguridadException e) {
        	  W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
          } catch (Q70LogonException e) {
				W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
          } catch (TransformerException e) {
        	  W83bClsTrazas.trazaError(null,"Error con cdigo: " + dni + " - ERROR: "+ e.getMessage(),e);
          }

          return email;
    }
	  
	  
	  
	  
	  public static String getTelefonoPersona(HttpServletRequest request,String dni)  {
		  String telefono = "";
          
          try {
        	  Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
        	  Q70InformacionSeguridadUsuario infUsuario;
        	  infUsuario = gestorSeguridad.createSecurityUserInfo(request);
	          
	          N38API sessionTolkit = infUsuario.getXLNESessionTolkit();
	          
	          
	          StringBuffer filtroPersona = new StringBuffer("(|");
	          filtroPersona.append("(dni=");
	          filtroPersona.append(dni);
	          filtroPersona.append(")");
	          filtroPersona.append(")");
	          Document document = sessionTolkit.n38ItemObtenerPersonas(filtroPersona.toString());
	          
	          NodeList lista = null;
	          
         
	            lista = XPathAPI.selectNodeList(document,"//elemento[@subtipo=\"n38persona\"]");
	            if (lista != null) {
	                  NodeList nlm = XPathAPI.selectNodeList(lista.item(0),
	                             "parametro[@id=\"telephonenumber\"]/valor/text()");
	                  if (nlm.getLength() > 0) {
	                       telefono = nlm.item(0).getNodeValue();
	                  }
	            }
          } catch (Q70SeguridadException e) {
        	  W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
          } catch (Q70LogonException e) {
				W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
          } catch (TransformerException e) {
        	  W83bClsTrazas.trazaError(null,"Error con cdigo: " + dni + " - ERROR: " + e.getMessage(),e);
          }

          return telefono;
    }
	  
	  

	  
	  
	  public static W83bUsuarioXLNetsBean getUsuarioXLNets(HttpServletRequest request)
	  throws TransformerException{
		  W83bUsuarioXLNetsBean usuarioBean = new W83bUsuarioXLNetsBean();
		  
		  if(null!=getParameters(request, "n38idioma")&&getParameters(request, "n38idioma").size()>0){
			  usuarioBean.setIdioma((String)getParameters(request, "n38idioma").get(0));
			  usuarioBean.setDniUsuario((String)getParameters(request, "dni").get(0));
			  usuarioBean.setNombrePersona((String)getNombrePersona(request, usuarioBean.getDniUsuario()));
			  usuarioBean.setTelefonoPersona((String)getTelefonoPersona(request, usuarioBean.getDniUsuario()));
			  usuarioBean.setMailPersona((String)getMailPersona(request, usuarioBean.getDniUsuario()));
			  usuarioBean.setPerfilXLNets(getParameters(request, "n38perfiles"));
			  usuarioBean.setIdUsuario((String)getParameters(request, "n38personauid").get(0));
			  usuarioBean.setPuestouid((String)getParameters(request, "n38puestouid").get(0));
			  usuarioBean.setSessionTokenXLNets(getSessionXML(request));
			  usuarioBean.setSessionTokenXLNetsDoc(getSessionXMLDoc(request));
			  List listaLogin = getParameters(request, "n38login"); 
			  usuarioBean.setLoginXLNets((listaLogin.size() == 0) ? null : (String) listaLogin.get(0));	
			  W83bClsTrazas.traza(usuarioBean,"n38idioma->"+usuarioBean.getIdioma());			  
			  W83bClsTrazas.traza(usuarioBean,"dni->"+usuarioBean.getDniUsuario());
			  W83bClsTrazas.traza(usuarioBean,"Nombre persona->"+usuarioBean.getNombrePersona());
			  W83bClsTrazas.traza(usuarioBean,"telefono persona->"+usuarioBean.getTelefonoPersona());
			  W83bClsTrazas.traza(usuarioBean,"mail persona->"+usuarioBean.getMailPersona());
			  W83bClsTrazas.traza(usuarioBean,"id->"+usuarioBean.getIdUsuario());			  
			  W83bClsTrazas.traza(usuarioBean,"n38perfiles->"+usuarioBean.getPerfilXLNets());			  
			  W83bClsTrazas.traza(usuarioBean,"n38login->"+(String) listaLogin.get(0));
			  W83bClsTrazas.traza(usuarioBean,"n38personauid->"+usuarioBean.getIdUsuario());
			  W83bClsTrazas.traza(usuarioBean,"n38puestouid->"+usuarioBean.getPuestouid());
		  }else{
			  usuarioBean = null;
		  }
		  return usuarioBean;
	  }
	  
	  public static boolean comprobarExistenciaUsuarioXLNets(HttpServletRequest request)
	  throws TransformerException{
		  
		  W83bClsTrazas.trazaError(null, "idioma user->"+getParameters(request, "n38idioma"), null);
		  
		  return(null!=getParameters(request, "n38idioma")&&getParameters(request, "n38idioma").size()>0);
		 
	  }
	  
		
		 public static String XLNetURL(HttpServletRequest req, String mod, String action) throws Exception {

		        String urlXLNet = Q70ListenerUtils.getApplicationProperty("URL_ACCESO");
	            StringBuffer urlXLNetb = new StringBuffer(urlXLNet);
		        String ctxPath = req.getContextPath();

		        String portal = req.getParameter("R01HPortal");
		        String pagina = req.getParameter("R01HPage");
		        String idioma = req.getParameter("R01HLang");     
		        if (portal!=null && pagina!=null && idioma!=null)
		        {   urlXLNetb.append("/").append(portal).append("-").append(pagina).append("/").append(idioma).append(ctxPath).append(mod).append(action);}
		        else
		        {   urlXLNetb.append(ctxPath).append(mod).append(action);}
		        return urlXLNetb.toString();

		    }

		 public static boolean permisosW83b(W83bUsuarioXLNetsBean usuarioBean){
			 
			 if(null!=usuarioBean.getPerfilXLNets()){

					 if(W83bClsConstantes.LISTADO_PERMISOS_W83B.contains(usuarioBean.getPermisoXlnet())){
						 return true;
					 }

			 }
			 return false;
		 }
		 
			
			/**
			 * Funcin que devuelve la provincia en funcin de la delegacin
			 * Si no pertenece a ninguna provincia se supone de servicios centrales y devuelve 
			 * @param codDelegacion
			 * @return 
			 */
			public static String elegirProvinciaDelegacion(List codDelegacion){
				

				if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES)){
					return W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES;
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_ALAVA)){
					return W83bClsConstantes.CONSTANTE_ALAVA;			
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_CONSULTA_ALAVA)){
					return W83bClsConstantes.CONSTANTE_ALAVA;			
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_GUIPUZKOA)){
					return W83bClsConstantes.CONSTANTE_GIPUZKOA;
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_CONSULTA_GUIPUZKOA)){
					return W83bClsConstantes.CONSTANTE_GIPUZKOA;
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_BIZKAIA)){
					return W83bClsConstantes.CONSTANTE_BIZKAIA;
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_CONSULTA_BIZKAIA)){
					return W83bClsConstantes.CONSTANTE_BIZKAIA;
				}
				

				
				return "";
			}
			
			
			/**
			 * Mira a ver si tiene permisos de Administrador o de consulta
			 * @param codDelegacion
			 * @return 
			 */
			public static String elegirAdministradorConsulta(List codDelegacion){
				if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES)){
					return W83bClsConstantes.CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES;
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_ALAVA)||
						codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_GUIPUZKOA)||
						codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_BIZKAIA)
						){
					return W83bClsConstantes.PERMISO_ADMINISTRADOR;
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_CONSULTA_ALAVA)||
						codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_CONSULTA_GUIPUZKOA)||
						codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_CONSULTA_BIZKAIA)){
					return W83bClsConstantes.PERMISO_CONSULTA;			
				}
				return "";
			}
			
			/**
			 * Funcin que devuelve la provincia en funcin de la delegacin
			 * Si no pertenece a ninguna provincia se supone de servicios centrales y devuelve 
			 * @param codDelegacion
			 * @return 
			 */
			public static String elegirServiciosCentralosODelegacion(List codDelegacion){

				
				if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES)){
					return W83bClsConstantes.CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES;
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_ALAVA)){
					return W83bClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_ALAVA;			
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_GUIPUZKOA)){
					return W83bClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_GUIPUZKOA;			
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_BIZKAIA)){
					return W83bClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_BIZKAIA;			
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_CONSULTA_ALAVA)){
					return W83bClsConstantes.CONSTANTE_PERMISO_CONSULTA_ALAVA;
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_CONSULTA_GUIPUZKOA)){
					return W83bClsConstantes.CONSTANTE_PERMISO_CONSULTA_GUIPUZKOA;
				}else if(codDelegacion.contains(W83bClsConstantes.CONSTANTE_PERMISO_CONSULTA_BIZKAIA)){
					return W83bClsConstantes.CONSTANTE_PERMISO_CONSULTA_BIZKAIA;
				}

				
				return "";
			}
			

}